package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.PlanTemplateItemDto;
import com.junmp.jyzb.api.bean.req.PlanTemplateReq;
import com.junmp.jyzb.entity.PlanTemplate;
import com.junmp.jyzb.entity.PlanTemplateItem;
import com.junmp.jyzb.service.PlanTemplateItemService;
import com.junmp.jyzb.service.PlanTemplateService;
import com.junmp.jyzb.mapper.PlanTemplateMapper;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.entity.BaseEntity;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/3 9:47
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
public class PlanTemplateServiceImpl extends ServiceImpl<PlanTemplateMapper, PlanTemplate> implements PlanTemplateService{
    @Resource
    private PlanTemplateItemService planTemplateItemService;

    /**
     * 分页查询预案信息
     * @param req
     * @return
     */
    @Override
    public PageResult<PlanTemplate> getPage(PlanTemplateReq req) {
        LambdaQueryWrapper<PlanTemplate> wp = this.createWrappers(req);
        Page<PlanTemplate> page = this.page(PageFactory.getDefaultPage(req), wp);
        return PageResultFactory.createPageResult(page);
    }

    /**
     * 查询预案信息集合
     * @param req
     * @return
     */
    @Override
    public List<PlanTemplate> getList(PlanTemplateReq req) {
        LambdaQueryWrapper<PlanTemplate> wp = this.createWrappers(req);
        return this.list(wp);
    }

    /**
     * 添加预案信息
     * @param req
     * @return
     */
    @Override
    public Boolean add(PlanTemplateReq req) {
        PlanTemplate bean = BeanPlusUtil.toBean(req, PlanTemplate.class);
        bean.setTemId(null);
        boolean flag = this.save(bean);
        if (flag) {
            List<PlanTemplateItem> itemList = req.getDtoList().stream().map(dto -> {
                PlanTemplateItem item = BeanPlusUtil.toBean(dto, PlanTemplateItem.class);
                item.setItemId(null);
                item.setTemId(bean.getTemId());
                return item;
            }).collect(Collectors.toList());
            planTemplateItemService.saveBatch(itemList);
        }
        return flag;
    }

    /**
     * 更新预案信息
     * @param req
     * @return
     */
    @Override
    public Boolean edit(PlanTemplateReq req) {
        PlanTemplate bean = BeanPlusUtil.toBean(req, PlanTemplate.class);
        bean.setUpdateTime(new Date());
        boolean flag = this.updateById(bean);
        List<PlanTemplateItemDto> dtoList = req.getDtoList();
        if (flag && CollectionUtil.isNotEmpty(dtoList) && dtoList.size() > 0) {
            planTemplateItemService.remove(Wrappers.<PlanTemplateItem>lambdaQuery().eq(PlanTemplateItem::getTemId, bean.getTemId()));
            List<PlanTemplateItem> itemList = req.getDtoList().stream().map(dto -> {
                PlanTemplateItem item = BeanPlusUtil.toBean(dto, PlanTemplateItem.class);
                item.setItemId(null);
                item.setTemId(bean.getTemId());
                return item;
            }).collect(Collectors.toList());
            planTemplateItemService.saveBatch(itemList);
        }
        return flag;
    }

    /**
     * 删除预案信息
     * @param req
     * @return
     */
    @Override
    public Boolean delete(PlanTemplateReq req) {
        boolean flag = this.removeById(req);
        if (flag){
            planTemplateItemService.remove(Wrappers.<PlanTemplateItem>lambdaQuery()
                    .eq(PlanTemplateItem::getTemId, req.getTemId()));
        }
        return flag;
    }

    /**
     * 查询预案信息详情
     * @param req
     * @return
     */
    @Override
    public List<PlanTemplateItem> getDetail(PlanTemplateReq req) {
        List<PlanTemplateItem> list = planTemplateItemService.list(Wrappers.<PlanTemplateItem>lambdaQuery()
                .eq(PlanTemplateItem::getTemId, req.getTemId()).orderByAsc(PlanTemplateItem::getTypeId));
        return list;
    }

    /**
     * 构建查询条件
     * @param req
     * @return
     */
    private LambdaQueryWrapper<PlanTemplate> createWrappers(PlanTemplateReq req) {
        LambdaQueryWrapper<PlanTemplate> wp = Wrappers.<PlanTemplate>lambdaQuery();
        wp.ge(StrUtil.isNotEmpty(req.getStartTime()), BaseEntity::getCreateTime, req.getStartTime());
        wp.le(StrUtil.isNotEmpty(req.getEndTime()), BaseEntity::getCreateTime, req.getEndTime());
        wp.eq(ObjectUtil.isNotEmpty(req.getTemGrade()), PlanTemplate::getTemGrade, req.getTemGrade());
        wp.like(ObjectUtil.isNotEmpty(req.getNote()), PlanTemplate::getNote, req.getNote());
        wp.like(ObjectUtil.isNotEmpty(req.getTemName()), PlanTemplate::getTemName, req.getTemName());
        wp.orderByDesc(BaseEntity::getCreateTime);
        return wp;
    }
}




