package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.PlanModuleReq;
import com.junmp.jyzb.entity.PlanModule;
import com.junmp.jyzb.service.PlanModuleService;
import com.junmp.jyzb.mapper.PlanModuleMapper;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.entity.BaseEntity;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/3 9:47
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
public class PlanModuleServiceImpl extends ServiceImpl<PlanModuleMapper, PlanModule> implements PlanModuleService {

    /**
     * 分页查询模块信息
     *
     * @param req
     * @return
     */
    @Override
    public PageResult<PlanModule> getPage(PlanModuleReq req) {
        LambdaQueryWrapper<PlanModule> wp = this.createWrappers(req);
        Page<PlanModule> page = this.page(PageFactory.getDefaultPage(req), wp);
        return PageResultFactory.createPageResult(page);
    }

    /**
     * 查询模块信息集合
     * @param req
     * @return
     */
    @Override
    public List<PlanModule> getList(PlanModuleReq req) {
        LambdaQueryWrapper<PlanModule> wp = this.createWrappers(req);
        return this.list(wp);
    }

    /**
     * 添加模块信息
     * @param req
     * @return
     */
    @Override
    public Boolean add(PlanModuleReq req) {
        PlanModule bean = BeanPlusUtil.toBean(req, PlanModule.class);
        bean.setMdId(null);
        return this.save(bean);
    }

    /**
     * 更新模块信息
     * @param req
     * @return
     */
    @Override
    public Boolean edit(PlanModuleReq req) {
        PlanModule bean = BeanPlusUtil.toBean(req, PlanModule.class);
        bean.setUpdateTime(new Date());
        return this.updateById(bean);
    }

    /**
     * 删除模块信息
     * @param req
     * @return
     */
    @Override
    public Boolean delete(PlanModuleReq req) {
        return this.removeById(req);
    }

    /**
     * 构建查询条件
     * @param req
     * @return
     */
    private LambdaQueryWrapper<PlanModule> createWrappers(PlanModuleReq req) {
        LambdaQueryWrapper<PlanModule> wp = Wrappers.<PlanModule>lambdaQuery();
        wp.ge(StrUtil.isNotEmpty(req.getStartTime()), BaseEntity::getCreateTime, req.getStartTime());
        wp.le(StrUtil.isNotEmpty(req.getEndTime()), BaseEntity::getCreateTime, req.getEndTime());
        wp.like(ObjectUtil.isNotEmpty(req.getMdName()), PlanModule::getMdName, req.getMdName());
        wp.like(ObjectUtil.isNotEmpty(req.getNote()), PlanModule::getNote, req.getNote());
        wp.like(ObjectUtil.isNotEmpty(req.getMdInfo()), PlanModule::getMdInfo, req.getMdInfo());
        wp.orderByDesc(BaseEntity::getCreateTime);
        return wp;
    }
}




