package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.req.PlanInitiationReq;
import com.junmp.jyzb.api.bean.req.UpdateOrderReq;
import com.junmp.jyzb.api.bean.vo.PlanInitOrgTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanInitTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanOrgTypeVo;
import com.junmp.jyzb.entity.PlanInitiationItem;
import com.junmp.jyzb.service.PlanInitiationItemService;
import com.junmp.jyzb.mapper.PlanInitiationItemMapper;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/3 9:47
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
public class PlanInitiationItemServiceImpl extends ServiceImpl<PlanInitiationItemMapper, PlanInitiationItem> implements PlanInitiationItemService{

    /**
     * 查询发起预案信息详情
     * @param req
     * @return
     */
    @Override
    public List<PlanOrgTypeVo> getDetail(PlanInitiationReq req) {
        return baseMapper.getDetail(req);
    }

    /**
     * 根据预案明细获取数据信息
     * @param planId
     * @return
     */
    @Override
    public List<PlanInitOrgTypeVo> getPlanDetail(Long planId) {
        return baseMapper.getPlanDetail(planId);
    }

    @Override
    public List<PlanInitTypeVo> getPlanInfo(PlanInitiationReq req) {
        return baseMapper.getPlanInfo(req.getPlanId());
    }
}




