package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.OrderV2Dto;
import com.junmp.jyzb.api.bean.query.OrderV2Req;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.*;
import com.junmp.jyzb.service.OrderV2Service;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class OrderV2ServiceImpl implements OrderV2Service {

    @Resource
    private JpBorrowReturnDetailMapper jpBorrowReturnDetailMapper;
    @Resource
    private JpBorrowReturnOrderMapper jpBorrowReturnOrderMapper;
    @Resource
    private JpFixUselessDetailMapper jpFixUselessDetailMapper;
    @Resource
    private JpFixUselessOrderMapper jpFixUselessOrderMapper;
    @Resource
    private JpNoborrowOrderMapper jpNoborrowOrderMapper;
    @Resource
    private JpNoborrowDetailMapper jpNoborrowDetailMapper;
    @Resource
    private JpPurchaseOrderMapper jpPurchaseOrderMapper;
    @Resource
    private JpPurchaseDetailMapper jpPurchaseDetailMapper;
    @Resource
    private JpTransferDetailMapper jpTransferDetailMapper;
    @Resource
    private JpTransferOrderMapper jpTransferOrderMapper;



    @Override
    public PageResult<OrderV2Dto> getOrderPageV2(OrderV2Req req) {
        Page<OrderV2Dto> page = PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
        List<OrderV2Dto> list=new ArrayList<>();
        int size=0;
        switch (req.getType()){
            case 1://采购
                list=jpPurchaseOrderMapper.getPage(req,(req.getPageNo() - 1) * req.getPageSize(), req.getPageSize());
                size=jpPurchaseOrderMapper.getCount(req);
                break;
            case 2://借用
            case 3://领用
            case 12://销毁
                list=jpBorrowReturnOrderMapper.getPage(req,(req.getPageNo() - 1) * req.getPageSize(), req.getPageSize());
                size=jpBorrowReturnOrderMapper.getCount(req);
                break;
            case 4://调拨
                list=jpTransferOrderMapper.getPage(req,(req.getPageNo() - 1) * req.getPageSize(), req.getPageSize());
                size=jpTransferOrderMapper.getCount(req);
                break;
            case 5://维修
            case 6://报废
                list=jpFixUselessOrderMapper.getPage(req,(req.getPageNo() - 1) * req.getPageSize(), req.getPageSize());
                size=jpFixUselessOrderMapper.getCount(req);
                break;
            case 13://无单据
                list=jpNoborrowOrderMapper.getPage(req,(req.getPageNo() - 1) * req.getPageSize(), req.getPageSize());
                size=jpNoborrowOrderMapper.getCount(req);
                break;

        }
        page.setRecords(list);
        page.setTotal(size);
        return PageResultFactory.createPageResult(page);
    }

    /**
     * 获取采购单详情
     * @param req
     * @return
     */
    @Override
    public List<JpPurchaseDetail> getPurchaseDetail(JpPurchaseDetail req) {
        return jpPurchaseDetailMapper.selectList(new LambdaQueryWrapper<JpPurchaseDetail>()
                .eq(JpPurchaseDetail::getOrderId,req.getOrderId()));
    }

    /**
     * 获取借用、领用、销毁单详情
     * @param req
     * @return
     */
    @Override
    public List<JpBorrowReturnDetail> getBorrowReturnDetail(JpBorrowReturnDetail req) {
        return jpBorrowReturnDetailMapper.selectList(new LambdaQueryWrapper<JpBorrowReturnDetail>()
                .eq(JpBorrowReturnDetail::getOrderId,req.getOrderId()));
    }

    /**
     * 获取调拨单详情
     * @param req
     * @return
     */
    @Override
    public List<JpTransferDetail> getTransferDetail(JpTransferDetail req) {
        return jpTransferDetailMapper.selectList(new LambdaQueryWrapper<JpTransferDetail>()
                .eq(JpTransferDetail::getOrderId,req.getOrderId()));
    }

    /**
     * 获取维修、报废单详情
     * @param req
     * @return
     */
    @Override
    public List<JpFixUselessDetail> getFixUselessDetail(JpFixUselessDetail req) {
        return jpFixUselessDetailMapper.selectList(new LambdaQueryWrapper<JpFixUselessDetail>()
                .eq(JpFixUselessDetail::getOrderId,req.getOrderId()));
    }

    /**
     * 获取无单据单详情
     * @param req
     * @return
     */
    @Override
    public List<JpNoborrowDetail> getNoBorrowDetail(JpNoborrowDetail req) {
        return jpNoborrowDetailMapper.selectList(new LambdaQueryWrapper<JpNoborrowDetail>()
                .eq(JpNoborrowDetail::getOrderId,req.getOrderId()));
    }
}
