package com.junmp.jyzb.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.QueryLogSummarySecondReq;
import com.junmp.jyzb.entity.LogSummarySecond;
import com.junmp.jyzb.service.LogSummarySecondService;
import com.junmp.jyzb.mapper.LogSummarySecondMapper;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

/**
* @author lxh专属坐骑
* @description 针对表【base_log_summary_second】的数据库操作Service实现
* @createDate 2023-12-08 14:44:38
*/
@Service
public class LogSummarySecondServiceImpl extends ServiceImpl<LogSummarySecondMapper, LogSummarySecond>
    implements LogSummarySecondService{

    @Override
    public PageResult<LogSummarySecond> getSecondInfoByLogSumId(QueryLogSummarySecondReq req) {
        LambdaQueryWrapper<LogSummarySecond> eq = new LambdaQueryWrapper<LogSummarySecond>()
                .eq(LogSummarySecond::getSummaryId, req.getSummaryId());
        Page<LogSummarySecond> page = page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }
}




