package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.junmp.jyzb.api.bean.req.DeviceMsgReq;
import com.junmp.jyzb.mapper.DeviceMsgMapper;
import com.junmp.jyzb.service.DeviceMsgService;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.message.api.bean.req.MessageSendReq;
import com.junmp.v2.message.db.entity.SysMessage;
import com.junmp.v2.message.db.service.SysMessageService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class DeviceMsgServiceImpl implements DeviceMsgService {

    @Resource
    private DeviceMsgMapper deviceMsgMapper;

    @Resource
    private SysMessageService sysMessageService;

    @Override
    public Boolean createDeviceMsgList(DeviceMsgReq req) {
        if (CollectionUtil.isNotEmpty(req.getMessageSendReqList())){
            //查询浙江省公安市下面的仓管员userIdsList
            List<String> glUserIdsList = deviceMsgMapper.getGLUserIdsList(1369509498032809012L);

            List<MessageSendReq> collect = req.getMessageSendReqList().stream().filter(messageSendReq ->
                    glUserIdsList.contains(messageSendReq.getReceiveUserIds())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(collect)){
                //删除该人员下面未读消息并重新添加
                List<String> userIdList = collect.stream().map(MessageSendReq::getReceiveUserIds).distinct().collect(Collectors.toList());
                deviceMsgMapper.deleteDeviceMsgList(userIdList);
                List<SysMessage> messageList = BeanPlusUtil.toBeanList(collect, SysMessage.class);
                sysMessageService.saveBatch(messageList);
            }

        }
        return null;
    }
}




