package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.hardWareReq.CabinetOutinlogReq;
import com.junmp.jyzb.entity.CabinetOutinlog;
import com.junmp.jyzb.mapper.CabinetOutinlogMapper;
import com.junmp.jyzb.service.CabinetOutinlogService;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class CabinetOutinlogServiceImpl  extends ServiceImpl<CabinetOutinlogMapper, CabinetOutinlog>
        implements CabinetOutinlogService {

    @Resource
    private CabinetOutinlogMapper cabinetOutinlogMapper;

    @Override
    public PageResult<CabinetOutinlog> getCabinetOutInLogPage(CabinetOutinlogReq req) {
        Page<CabinetOutinlog> page= PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize());
//        LambdaQueryWrapper<CabinetOutinlog> wrappr = this.createWrappr(req);
//        page = page(page, wrappr);
        page=cabinetOutinlogMapper.getCabinetOutInLogPage(page,req);
        return PageResultFactory.createPageResult(page);
    }

    @Override
    public List<CabinetOutinlog> getListByPrictureUrl(String url) {
        CabinetOutinlogReq cabinetOutinlogReq = new CabinetOutinlogReq();
        cabinetOutinlogReq.setPhoto( url);
        LambdaQueryWrapper<CabinetOutinlog> wrappr = createWrappr(cabinetOutinlogReq);
        return list(wrappr);
    }

    private LambdaQueryWrapper<CabinetOutinlog> createWrappr(CabinetOutinlogReq req) {
        LambdaQueryWrapper<CabinetOutinlog> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        wrapper.like(ObjectUtil.isNotEmpty(req.getName()),CabinetOutinlog::getName,req.getName());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getId()),CabinetOutinlog::getId,req.getId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getState()),CabinetOutinlog::getState,req.getState());
        wrapper.like(ObjectUtil.isNotEmpty(req.getUserName()),CabinetOutinlog::getUserName,req.getUserName());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getBoxNo()),CabinetOutinlog::getBoxNo,req.getBoxNo());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getPhoto()),CabinetOutinlog::getPhoto,req.getPhoto());
        wrapper.like(ObjectUtil.isNotEmpty(req.getEpc()),CabinetOutinlog::getEpc,req.getEpc());
        wrapper.like(ObjectUtil.isNotEmpty(req.getDevSn()),CabinetOutinlog::getDevSn,req.getDevSn());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getOrgId()),CabinetOutinlog::getOrgId,req.getOrgId());
        wrapper.ge(ObjectUtil.isNotEmpty(req.getStartTime()),CabinetOutinlog::getOperationTime,req.getStartTime());
        wrapper.le(ObjectUtil.isNotEmpty(req.getEndTime()),CabinetOutinlog::getOperationTime,req.getEndTime());

        wrapper.orderByDesc(CabinetOutinlog::getOperationTime);
        return wrapper;
    }
}
