package com.junmp.jyzb.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.query.*;
import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.SummaryLogReq;
import com.junmp.jyzb.api.bean.req.*;
import com.junmp.jyzb.api.bean.ws.RegCabinetReq;
import com.junmp.jyzb.api.enums.CabinetStateEnum;
import com.junmp.jyzb.api.exception.JYZBAppException;
import com.junmp.jyzb.api.exception.enums.CabinetExceptionEnum;
import com.junmp.jyzb.api.exception.enums.WsCabinetExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/4/2 下午4:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Service
@Slf4j
public class CabinetAppBizServiceImpl implements CabinetAppBizService {


    @Resource
    private CabinetService cabinetService;


    @Resource
    private CabinetBoxService cabinetBoxService;

    @Resource
    private EquipmentTypeService equipmentTypeService;

    @Resource
    private PolicemanService policemanService;

    @Resource
    private PoliceFingerService policeFingerService;

    @Resource
    private ApplicationService applicationService;

    @Resource
    private InventoryService inventoryService;


    @Resource
    private LogSummaryService logSummaryService;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean receiveCabinetPoliceData(CabinetUploadReq req) {
        List<PoliceListReq> policeReqList = req.getPoliceList();
        //1-查询单警柜是否存在
        Cabinet cabinet = cabinetService.getOne(new LambdaQueryWrapper<Cabinet>().eq(Cabinet::getDevSn, req.getDevSn()));
        if (null != cabinet) {
            if (CollUtil.isNotEmpty(policeReqList)) {
                //2- 警员的列表
                Set<String> reqPoliceIds = policeReqList.stream().map(PoliceListReq::getPoliceId).collect(Collectors.toSet());
                //3-
                //policemanService.list(new LambdaQueryWrapper<Policeman>().eq(Policeman::getOrgId, orgList.getOrgId()));
            } else {
                //没有任何需要更新的信息
            }

        } else {
            //提示先创建单警柜
        }
        return true;
    }

    @Override
    public String regCabinet(RegCabinetReq req) {
        UpdateCabinetReq addReq = BeanPlusUtil.toBean(req, UpdateCabinetReq.class);
        return cabinetService.addCabinetInfo(addReq);
    }

    @Override
    public String updateCabinet(RegCabinetReq req) {
        if (StrUtil.isBlank(req.getCabinetId())) {
            throw new JYZBAppException(WsCabinetExceptionEnum.WS_CABINET_ID_EMPTY_ERROR);
        }
        return regCabinet(req);
    }

    @Override
    public boolean delCabinet() {
        return false;
    }


    @Override
    public CabinetDto delCabinetBox(UpdateCabinetReq req) {
        return cabinetBoxService.DeleteBox(req);
    }


    /**
     * 修改警柜状态
     *
     * @param orgCode  隶属的组织机构
     * @param serialNo 单警柜的序号
     * @param stateVal 状态
     * @see CabinetStateEnum
     */
    @Override
    public boolean updateCabinetState(String orgCode, String serialNo, CabinetStateEnum stateVal) {
        LambdaUpdateWrapper<Cabinet> wp = Wrappers.lambdaUpdate();
        wp.set(Cabinet::getOnlineState, stateVal.getValue())
                .eq(Cabinet::getDevSn, serialNo)
                .eq(Cabinet::getOrgCode, orgCode);
        return cabinetService.update(wp);
    }

    @Override
    public boolean existsCabinetSerial(String serialNo) {
        LambdaQueryWrapper<Cabinet> wp = Wrappers.lambdaQuery();
        wp.eq(Cabinet::getDevSn, serialNo);
        return cabinetService.count(wp) > 0;
    }

    @Override
    public PubOrg getPubOrgByCode(String orgCode) {
        return null;
    }

    @Override
    public CabinetDto showOneCabinet(CabinetReq req) {
        // 查询单警柜信息
        Cabinet cabinet = CabinetExistByNum(req.getDevSn());

        // 查询单警柜的箱门信息
        List<CabinetBox> list = cabinetBoxService.list(new LambdaQueryWrapper<CabinetBox>()
                .eq(ObjectUtil.isNotEmpty(cabinet.getId()), CabinetBox::getCabinetId, cabinet.getId())
                .eq(ObjectUtil.isNotEmpty(req.getContainType()), CabinetBox::getContainType, req.getContainType())
                .orderByAsc(CabinetBox::getBoxNo));

        List<CabinetBoxDto> boxList = list.stream()
                .map(cabinetBox -> {
                    CabinetBoxDto cabinetBoxDto = new CabinetBoxDto();
                    BeanPlusUtil.copyProperties(cabinetBox, cabinetBoxDto);
                    return cabinetBoxDto;
                })
                .collect(Collectors.toList());

        // 将单警柜的信息和它的箱门信息返回
        CabinetDto cabinetDto = new CabinetDto();
        BeanPlusUtil.copyProperties(cabinet, cabinetDto);
        cabinetDto.setCabinetBoxList(boxList);

        return cabinetDto;
    }

    @Override
    public String exprotSizeAndType(QueryEquipmentTypeReq req) {
        return equipmentTypeService.exportSizeAndType(req) ;
    }

    @Override
    public PolicemanDto addPolicemanFromCab(CabinetPolicemanReq req) {
        return policemanService.AddPolicemanFromCab(req);
    }
    @Override
    public PolicemanDto delPolicemanFromCab(CabinetPolicemanReq req) {
        return policemanService.DeletePoliceFromCab(req);
    }

    @Override
    public PolicemanDto UpdatePoliceFromCab(CabinetPolicemanReq req) {
        return policemanService.UpdatePoliceFromCab(req);
    }

    @Override
    public List<CabinetPoliceDto> GetListByOrg(PolicemanReq req) {
        return policemanService.GetListByOrgAsync(req);
    }

    @Override
    public CabinetPoliceDto AddFaceInfo(CabinetPolicemanReq req) {
        return policemanService.AddFaceInfo(req);
    }

    @Override
    public CabinetPoliceDto UpdateFaceInfo(CabinetPolicemanReq req) {
        return policemanService.UpdateFaceInfo(req);
    }

    @Override
    public Policeman SearchFaceInfo(CabinetPolicemanReq req) {
        return policemanService.SearchFaceInfo(req);
    }

    @Override
    public CabinetPoliceDto updateFingerInfo(CabinetPolicemanReq req) {
        List<Integer> collect = req.getFingerList().stream().map(UpdatePoliceFingerReq::getId).collect(Collectors.toList());
        if (collect.size()<1|| CollectionUtil.isEmpty(collect)){
            throw new JYZBAppException(WsCabinetExceptionEnum.WS_CABINET_BOX_ID_EMPTY_ERROR);
        }
        return policeFingerService.insertOrUpdateFingerInfoFromCab(req) ;
    }

    @Override
    public CabinetPoliceDto addFingerInfo(CabinetPolicemanReq req) {

        return policeFingerService.insertOrUpdateFingerInfoFromCab(req);
    }

    @Override
    public CabinetPoliceDto deleteFinger(CabinetPolicemanReq req) {
        return policeFingerService.deleteFinger(req);
    }

    @Override
    public CabinetPoliceDto searchFingerInfo(PolicemanFingerReq req) {
        return policeFingerService.searchFingerInfo(req);
    }

    @Override
    public UploadPolicePhotoDto uploadPolicePhoto(UploadPolicePhotoReq req) {
        return policemanService.uploadPolicePhoto(req.getPicture(),req);
    }

    @Override
    public CabinetPoliceDto policeBindBoxFormCab(CabinetPolicemanReq req) {
        return policemanService.PoliceBindBoxFormCab(req);
    }


    @Override
    public CabinetDto regCabinetBox(UpdateCabinetReq req) {
        return cabinetBoxService.AddOrUpdateBoxInfo(req);
    }

    @Override
    public CabinetDto upCabinetBox(UpdateCabinetReq req) {
        List<String> collect = req.getCabinetBoxList().stream().map(UpdateCabinetBoxReq::getId).collect(Collectors.toList());

        if (collect.size()<1|| CollectionUtil.isEmpty(collect)){
            throw new JYZBAppException(WsCabinetExceptionEnum.WS_CABINET_BOX_ID_EMPTY_ERROR);
        }
        return cabinetBoxService.AddOrUpdateBoxInfo(req);
    }




    public Cabinet CabinetExistByNum(String serverNum) {
        Cabinet one = cabinetService.getOne(new LambdaQueryWrapper<Cabinet>()
                .eq(ObjectUtil.isNotEmpty(serverNum), Cabinet::getDevSn, serverNum));
        if (ObjectUtil.isNull(one)) {
            throw new ServiceException(CabinetExceptionEnum.CABINET_ISNOT_EXISTS);
        }
        return one;
    }

    @Override
    public Application getVersion(ApplicationReq req) {
        return applicationService.GetOne(req);
    }

    @Override
    public CabinetPoliceDto uploadLogs(CabinetPolicemanReq req) {
        return null;
    }

    @Override
    public Boolean cabinetLogsRecord(List<SummaryLogReq> req) {
        //插入数据库
        return logSummaryService.saveOutAndInLogs(req);
    }

    @Override
    public String boxBindEquipment(PoliceEquipmentDetailReq req) {

        return inventoryService.EqsBindOrUnbindCabinet(req);
    }

    @Override
    public Date getCurrentTime() {
        return DateTimeUtil.getCurrentDateTime();
    }

    @Override
    public Boolean getEqsState(PoliceEquipmentDetailReq req) {
        return inventoryService.getEqsState(req);
    }

}
