package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.WarehouseInfoDto;
import com.junmp.jyzb.api.bean.dto.WarehouseDto;
import com.junmp.jyzb.api.bean.query.WarehouseReq;
import com.junmp.jyzb.api.bean.req.OpenDoorReq;
import com.junmp.jyzb.api.bean.req.UpdateWarehouseReq;
import com.junmp.jyzb.api.bean.query.WsWarehouseReq;
import com.junmp.jyzb.entity.Temp.HumidityAndtemperature;
import com.junmp.jyzb.entity.Warehouse;

import java.io.UnsupportedEncodingException;
import java.util.List;

public interface WarehouseService extends IService<Warehouse> {

    /**
     * 查询状态
     *
     * @param req
     */
    WsWarehouseReq CheckState(WarehouseReq req);
    /**
     * 新增
     *
     * @param req
     */
    String AddWarehouse(UpdateWarehouseReq req);

    /**
     * 远程开门
     *
     * @param req
     */
    String OpenDoor(OpenDoorReq req) throws UnsupportedEncodingException;
    /**
     * 查询单个仓库信息
     *
     * @param req
     */
    WarehouseDto getOneWarehouse(WarehouseReq req);

//    ResponseResult deleteWarehouse(Map<String, Object> msg);
    boolean DeleteWarehouse(UpdateWarehouseReq req);

    /**
     * 编辑
     *
     * @param req
     */
    boolean updateWarehouse(UpdateWarehouseReq req);


    boolean changeWarehouseState(WarehouseReq req);

    List<WarehouseDto> getAllWarehouse(Long orgId,Integer state,Integer warehousetType);


    //通过仓库id 判断仓库是否存在
    Warehouse WarehoustExist(String id);

    boolean SetInventoryInfo(String id);

    List<WarehouseInfoDto> alignWarehouseInfo(UpdateWarehouseReq req);

    boolean updateHumidityAndtemperature(HumidityAndtemperature req);

    List<HumidityAndtemperature> showHumidityAndtemperature(WarehouseReq req);

    void HumidityAndtemperatureExport(WarehouseReq req);

    Warehouse GetWareHouseInfoByRedis(WarehouseReq req);

    List<String> checkWarehouseList(List<String> locationNameList);
}
