package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.SupplierInfoDto;
import com.junmp.jyzb.api.bean.dto.SupplierDto;
import com.junmp.jyzb.api.bean.query.QuerySupplierReq;
import com.junmp.jyzb.api.bean.req.UpdateSupplierReq;
import com.junmp.jyzb.entity.Supplier;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

public interface SupplierService extends IService<Supplier> {

    Object addEs();

    /**
     * 新增
     *
     * @param req
     */
    String AddSupplier(UpdateSupplierReq req);

    /**
    * @Author: Zhaojw
    * @Description: 检查供应商是否存在
    * @DateTime: 2023/7/29 10:49
    * @Params:
    * @Return
    */
    public List<String> CheckSupplierList(List<String> req);

    /**
     * 删除
     *
     * @param req
     */
    boolean DeleteSupplier(UpdateSupplierReq req);

    /**
     * 编辑
     *
     * @param req
     */
    boolean UpdateSupplier(UpdateSupplierReq req);

    /**
     * 列表信息
     *
     * @param req
     */
    List<SupplierDto> ShowSupplier(QuerySupplierReq req);

    /**
     * 更改状态
     *
     * @param req
     */
    Boolean ChangeSupplierState(UpdateSupplierReq req);

    PageResult<Supplier> ShowSupplierPage(QuerySupplierReq req);

    List<SupplierInfoDto> alignSupplierInfo(UpdateSupplierReq req);

    List<String> checkSupplierList(List<String> supplierNameList);
}
