package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.UpdateOrgReq;
import com.junmp.jyzb.entity.PubOrg;

import java.util.List;
import java.util.Map;

public interface PubOrgService extends IService<PubOrg> {



    List<Map<String, Object>> setShortName(Map<String, Object> orgId);

    List<Long> getLowerOrg(Long orgId);

    Boolean setOrgParentIds();

    List<OrgDto> getOrgList(QueryOrgReq req);

    OrgDto getOrgHierarchy(QueryOrgReq req);
    List<OrgDto> getLowOrg(QueryOrgReq req);

    Boolean ChangeState(UpdateOrgReq req);

    //根据组织机构id查询出组织机构是否存在
    PubOrg PubOrgExist(Long id);

    //根据组织机构Code查询出组织机构是否存在
    PubOrg PubOrgCodeExist(String orgCode);

    //通过组织机构id获取上一层的组织机构数据
    OrgDto getUpOrgInfo(QueryOrgReq req);

    Long addPubOrg(UpdateOrgReq req);

    boolean updatePubOrg(UpdateOrgReq req);

    PubOrg getOneOrgInfo(UpdateOrgReq req);

    Long findCodeToOrgId(PubOrg pubOrg);

    List<OrgDto> getTree(QueryOrgReq req);
}
