package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.req.PlanTemplateReq;
import com.junmp.jyzb.entity.PlanTemplate;
import com.junmp.jyzb.entity.PlanTemplateItem;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/3 9:47
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public interface PlanTemplateService extends IService<PlanTemplate> {

    /**
     * 分页查询预案信息
     * @param req
     * @return
     */
    PageResult<PlanTemplate> getPage(PlanTemplateReq req);

    /**
     * 查询预案信息集合
     * @param req
     * @return
     */
    List<PlanTemplate> getList(PlanTemplateReq req);

    /**
     * 添加预案信息
     * @param req
     * @return
     */
    Boolean add(PlanTemplateReq req);

    /**
     * 更新预案信息
     * @param req
     * @return
     */
    Boolean edit(PlanTemplateReq req);

    /**
     * 删除预案信息
     * @param req
     * @return
     */
    Boolean delete(PlanTemplateReq req);

    /**
     * 查询预案信息详情
     * @param req
     * @return
     */
    List<PlanTemplateItem> getDetail(PlanTemplateReq req);
}