package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.req.PlanInitiationReq;
import com.junmp.jyzb.api.bean.vo.PlanInitTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanTypeVo;
import com.junmp.jyzb.entity.PlanInitiation;
import com.junmp.jyzb.entity.PlanInitiationItem;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/3 9:46
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public interface PlanInitiationService extends IService<PlanInitiation> {

    /**
     * 分页查询发起预案信息
     * @param req
     * @return
     */
    PageResult<PlanInitiation> getPage(PlanInitiationReq req);

    /**
     * 查询发起预案信息集合
     * @param req
     * @return
     */
    List<PlanInitiation> getList(PlanInitiationReq req);

    /**
     * 查询发起预案信息详情
     * @param req
     * @return
     */
    PlanInitiation getDetail(PlanInitiationReq req);

    /**
     * 添加发起预案信息
     * @param req
     * @return
     */
    Boolean add(PlanInitiationReq req);

    /**
     * 更新发起预案信息
     * @param req
     * @return
     */
    Boolean edit(PlanInitiationReq req);

    /**
     * 删除发起预案信息
     * @param req
     * @return
     */
    Boolean delete(PlanInitiationReq req);

    /**
     * 根据装备获取其库存信息
     * @param req
     * @return
     */
    List<PlanInitTypeVo> getDetailList(PlanInitiationReq req);

    /**
     * 查询发起预案单信息详情
     * @param req
     * @return
     */
    List<PlanInitTypeVo> getPlanDetail(PlanInitiationReq req);

    Boolean updateToFinished(PlanInitiationReq req);

    Boolean createUseOrder(PlanInitiationReq req);

    Boolean createReturnOrder(PlanInitiationReq req);
}
