package com.junmp.jyzb.service;

import com.junmp.jyzb.api.bean.dto.LogSummaryDto;
import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.CabinetLogsRecordReq;
import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.OutInLogsReq;
import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.SummaryLogReq;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.entity.LogSummary;
import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.v2.auth.api.bean.login.LoginUser;
import com.junmp.v2.db.api.page.PageResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* @author lxh专属坐骑
* @description 针对表【base_log_summary】的数据库操作Service
* @createDate 2023-10-13 08:29:36
*/
public interface LogSummaryService extends IService<LogSummary> {

    PageResult<LogSummary> ShowInOutRecordsByItems(LogSummaryReq req);

    //本地主机返回出入库结果
    Boolean processInventoryRecords(OutInLogsReq req);

    PageResult<LogSummary> ShowInOutRecords(LogSummaryReq req);

    LogSummaryDto ShowInOutRecordsByItemsCount(LogSummaryReq req);

    PageResult<LogSummaryDto> RecordSumByOrderId(LogSummaryReq req);

    LogSummaryDto RecordSumByOrderIdCount(LogSummaryReq req);


    //添加出入库日志（根据装备明细进行汇总创建）
    Boolean addLogSummaryByInv(List<InventoryReq> list,String orderId,String orderCode,String bussiness,Integer deviceType,String locationType,String userName,String orgName,String device);

    //添加出入库日志(根据logSummaryReq实体类直接创建)
    Map<String,List<String>> addLogSummaryByClass(List<LogSummaryReq> list,String bussinessType);

    Map<String,LogSummaryReq> setLogDetailToMap(List<InventoryReq> list,Map<String,LogSummaryReq> logMap,String bussiness);

    Map<String,LogSummaryReq> setLogSummaryToMap(Map<String,LogSummaryReq> logMap, String userName, String orgName,
                                                 String locationId, String bussinessType, String typeName, String locationName,
                                                 String orderId, String orderCode, Long orgId,String locationState,
                                                 Integer deviceType, Integer subNum, String locationType, Date createTime, String photo,String device);


    LogSummaryReq setLogSummary(String userName,String orgName, String typeName, String locationId, String locationName, Integer subNum,
                                       String orderId, String orderCode, String bussinesstype, Long orgId, String outInState,
                                Integer devideType,String locationType,Date createTime,String photo,String device);

    List<LogSummaryReq> selectByOrderCode(String bussinessCode,Long orgId,List<String> epcList);

    Boolean saveOutAndInLogs(List<SummaryLogReq> req);
}
