package com.junmp.jyzb.service;



import com.junmp.v2.db.api.page.PageResult;
import com.junmp.jyzb.api.bean.dto.hardWareDto.*;
import com.junmp.jyzb.api.bean.query.hardWareReq.*;
import com.junmp.jyzb.entity.Application;
import com.junmp.jyzb.entity.CabinetOutinlog;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface HardWareService {

    /**
     * 获取系统时间
     * @return
     */
    Date getServerTime();

    /**
     * 获取单警柜警员信息
     * @param req
     * @return
     */
    List<HardCabPoliceDto> getAllPoliceByCabinet(HardWareCabReq req);

    /**
     * 获取epc信息
     */
    Map<String,String> GetEpcInfo(HardWareCabReq req);

    /**
     * 获取类型列表
     * @param req
     * @return
     */
    List<TypeDto> getListEquipmentDetail(HardWareCabReq req);

    /**
     * 获取类型号型列表
     * @param req
     * @return
     */
    List<SizeDto> getListEquipmentSizeNoSign(HardWareCabReq req);

    /**
     * 获取警员绑定装备列表
     * @param req
     * @return
     */
    EqsDto getBindEqu(HardWarePoliceReq req);

    /**
     * 修改单警柜和警员信息
     * @param req
     * @return
     */
    Boolean updatePoliceAndCabinet(HardWarePoliceReq req);

    /**
     * 获取软件版本更新
     * @param req
     * @return
     */
    Application getLastUpdate(HardWarePoliceReq req);

    /**
     * 根据设备号和版本号获取版本更新内容以及设备号是否需要升级
     * @param req
     * @return
     */
    LastUpAndUpgradeDto GetLastUpdateAndUpgrade(LastUpAndUpgradeReq req);

    /**
     * 库存
     * @param req
     * @return
     */
    InvCabDto inventoryCabinet(HardWareCabReq req);

    /**
     * 上报单警柜操作日志
     * @param req
     * @return
     */
    Boolean addWorklog(HardWareCabReq req);

    /**
     * 获取公共柜下绑定的警员信息（公共柜使用）
     * @param req
     * @return
     */
    List<GetCabinetPolicemanMultipleDto> getCabinetPolicemanMultiple(HardWareCabReq req);

    /**
     * 用户箱门绑定（公共柜）
     * @param req
     * @return
     */
    Boolean addPoliceAndCabinetMutiple(HardWareCabReq req);

    /**
     * 绑定单警柜和警员信息
     * @param req
     * @return
     */
    Boolean AddPoliceAndCabinet(HardWarePoliceReq req);

    /**
     * 解绑单警柜和警员信息
     * @param req
     * @return
     */
    Boolean deletePoliceAndCabinet(HardWarePoliceReq req);

    /**
     * 修改单警柜整柜模式
     * @param req
     * @return
     */
    Boolean changeCabinetType(HardWareCabReq req);

    /**
     * 公共柜箱门绑定装备
     * @param req
     * @return
     */
    List<HardWareInvDto> bindingInventory(HardWareCabReq req);

    /**
     * 上传RFID离线数据
     * @param req
     * @return
     */
    List<UploadRFIDListInnerDto> uploadRFIDListInner(UploadRFIDListInnerReq req);

    /**
     * 上传RFID数据
     * @param req
     * @return
     */
    List<UploadRFIDInnerDto> uploadRFIDInner(UploadRFIDInnerReq req);

    /**
     * 值班柜上传出入库日志
     * @param req
     * @return
     */
    Boolean addInOutlog(AddInOutLogReq req);

    /**
     * 人员绑定装备（与单警柜无关）
     * @param req
     * @return
     */
    Object bindingInventoryByPoliceId(BindingInventoryByPoliceIdReq req);

    /**
     * 上传日志文件
     * @param req
     * @return
     */
    Boolean uploadLog(UploadLogReq req);

    /**
     * 上传图片文件
     * @param req
     * @return
     */
    Boolean uploadPic(UploadPicReq req);

    /**
     * 更新成功修改设备版本号
     * @param req
     * @return
     */
    Boolean UpdateCabinetVersion(LastUpAndUpgradeReq req);

    PageResult<CabinetOutinlog> getCabinetOutInLogPage(CabinetOutinlogReq req);
}
