package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.TypeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentTypeReq;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.v2.db.api.page.PageResult;

import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface EquipmentTypeService extends IService<EquipmentType> {
    String addEquipment(UpdateEquipmentTypeReq req );

    String GetEquipmentByIds(QueryEquipmentTypeReq req );

    String GetEquipmentBySizeIds(QueryEquipmentTypeReq req );
    Boolean deleteEquipment(UpdateEquipmentTypeReq req);
    Boolean updateEquipment(UpdateEquipmentTypeReq msg);
    Boolean changeEquipmentState(UpdateEquipmentTypeReq req);
    List<EquipmentTypeDto> getEquipmentList(QueryEquipmentTypeReq req);
    EquipmentTypeDto getEquipment(QueryEquipmentTypeReq req );
    List<EquipmentTypeDto> getLowType(QueryEquipmentTypeReq orgId);

    List<EquipmentTreeDto> GetTypeTree(QueryEquipmentTypeReq req);

    List<TypeDto> alignTypeInfo(UpdateEquipmentTypeReq req);

    String exportSizeAndType(QueryEquipmentTypeReq req);

    PageResult<EquipmentTreeDto> getTypePage(QueryEquipmentTypeReq req);
}
