package com.junmp.jyzb.service;

import com.junmp.jyzb.api.bean.dto.CabinetDto;
import com.junmp.jyzb.api.bean.dto.CabinetPoliceDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.dto.UploadPolicePhotoDto;
import com.junmp.jyzb.api.bean.query.*;
import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.SummaryLogReq;
import com.junmp.jyzb.api.bean.req.*;
import com.junmp.jyzb.api.bean.ws.RegCabinetReq;
import com.junmp.jyzb.api.enums.CabinetStateEnum;
import com.junmp.jyzb.entity.Application;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.jyzb.entity.PubOrg;

import java.util.Date;
import java.util.List;

/**
 * <pre>
 *
 * 描述：单警柜应用的服务接口
 * 版本：1.0.0
 * 日期：2024/4/2 下午4:47
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public interface CabinetAppBizService {


    /**
     * 接收来自单警柜推送的警员数据
     *
     * @see CabinetUploadReq
     */
    boolean receiveCabinetPoliceData(CabinetUploadReq req);

    /**
     * 注册单警柜
     */
    String regCabinet(RegCabinetReq req);

    /**
     * 更新单警柜
     */
    String updateCabinet(RegCabinetReq req);

    /**
     * 删除单警柜
     */
    boolean delCabinet();



    /**
     * 删除柜门信息
     */
    CabinetDto delCabinetBox(UpdateCabinetReq req);

    /**
     * 修改警柜状态
     *
     * @param orgCode  隶属的组织机构
     * @param serialNo 单警柜的序号
     * @param stateVal 状态
     * @see CabinetStateEnum
     */
    boolean updateCabinetState(String orgCode, String serialNo, CabinetStateEnum stateVal);


    /**
     * 检查当前序号是否已注册
     *
     * @param serialNo
     */
    boolean existsCabinetSerial(String serialNo);


    /**
     * 根据组织机构编码获取组织机构信息
     *
     * @param orgCode 组织机构代码
     */
    PubOrg getPubOrgByCode(String orgCode);

    /**
     * 通过单警柜id进行查询单个单警柜信息及其箱门信息
     *
     * @param req
     * @return
     */
    CabinetDto showOneCabinet(CabinetReq req);

    /**
     * 同步号型类型，组织机构信息
     * @param req
     * @return
     */
    String exprotSizeAndType(QueryEquipmentTypeReq req);

    /**
     *添加警员信息
     * @param req
     * @return
     */
    PolicemanDto addPolicemanFromCab(CabinetPolicemanReq req);

    /**
     * 注册单警柜柜门
     * @param req
     * @return
     */
    CabinetDto regCabinetBox(UpdateCabinetReq req);

    /**
     * 编辑单警柜柜门
     * @param req
     * @return
     */
    CabinetDto upCabinetBox(UpdateCabinetReq req);


    /**
     * 删除警员信息
     * @param req
     * @return
     */
    PolicemanDto delPolicemanFromCab(CabinetPolicemanReq req);

    /**
     * 修改警员信息
     * @param req
     * @return
     */
    PolicemanDto UpdatePoliceFromCab(CabinetPolicemanReq req);

    /**
     * 获取警员信息
     * @param req
     * @return
     */
    List<CabinetPoliceDto> GetListByOrg(PolicemanReq req);

    /**
     * 新增人脸信息
     * @param req
     * @return
     */
    CabinetPoliceDto AddFaceInfo(CabinetPolicemanReq req);

    CabinetPoliceDto UpdateFaceInfo(CabinetPolicemanReq req);

    Policeman SearchFaceInfo(CabinetPolicemanReq req);

    CabinetPoliceDto updateFingerInfo(CabinetPolicemanReq req);

    CabinetPoliceDto addFingerInfo(CabinetPolicemanReq req);

    CabinetPoliceDto deleteFinger(CabinetPolicemanReq req);

    CabinetPoliceDto searchFingerInfo(PolicemanFingerReq req);

    UploadPolicePhotoDto uploadPolicePhoto(UploadPolicePhotoReq req);

    CabinetPoliceDto policeBindBoxFormCab(CabinetPolicemanReq req);

    Application getVersion(ApplicationReq req);

    CabinetPoliceDto uploadLogs(CabinetPolicemanReq req);

    Boolean cabinetLogsRecord(List<SummaryLogReq> req);

    String boxBindEquipment(PoliceEquipmentDetailReq req);

    Date getCurrentTime();

    Boolean getEqsState(PoliceEquipmentDetailReq req);
}
