package com.junmp.jyzb.service;

import com.junmp.jyzb.api.bean.query.QueryBusFormReq;
import com.junmp.jyzb.api.bean.req.UpdateBusFormReq;
import com.junmp.jyzb.entity.BusForm;
import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.entity.OrderNum;
import com.junmp.v2.db.api.page.PageResult;


/**
* @author lxh专属坐骑
* @description 针对表【base_bus_form】的数据库操作Service
* @createDate 2023-09-25 10:16:46
*/
public interface BusFormService extends IService<BusForm> {

    /**
     * 创建业务单、修改业务单
     * @return
     */
    String AddBussinessOrder(UpdateBusFormReq req);

    //查看业务单（可根据条件查询）
    PageResult<BusForm> showBussinessOrder(QueryBusFormReq req);

    //更新报废数量
    boolean updateBrokenResult(BusForm busForm);

     boolean addOrRevokeAgentBrokenNum(UpdateBusFormReq req,boolean flag);

    Object showOrderByBusOrderId(QueryBusFormReq req);

    boolean delToSubmitOrder(UpdateBusFormReq req);

    //上级单位报废发送消息
    void sendMsgByRemove(BusForm busForm);

    boolean updateBrokenResultByUpper(BusForm busForm);

    //设置单据单号
    OrderNum setOrderCode(String bussinessType, Long orgId);
}
