package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.tjDto.TjOrgPriceDto;
import com.junmp.jyzb.entity.PriceSumSummary;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface PriceSumSummaryMapper extends BaseMapper<PriceSumSummary> {




    TjOrgPriceDto TjOrgPrice(@Param("orgId") String orgId,
                                   @Param("year") Integer year,
                                   @Param("typeIdsList") List<String> typeIdsList,
                                   @Param("sizeNameList")List<String> sizeNameList,
                                   @Param("typeName") String typeName);

    void setSizeName(@Param("sizeId") String id, @Param("sizeName") String name);

    void setTypeName(@Param("typeId") String id, @Param("typeName") String name);

    TjOrgPriceDto TjOrgPriceLeve4(@Param("orgId") Long orgId,
                                  @Param("year") Integer year,
                                  @Param("typeIdsList") List<String> typeIdsList,
                                  @Param("sizeNameList")List<String> sizeNameList,
                                  @Param("levelFlag")Integer levelFlag,
                                  @Param("typeName") String typeName);



    TjOrgPriceDto TjOrgPriceBySelf(@Param("orgId") Long orgId,
                                   @Param("year") Integer year,
                                   @Param("typeIdsList") List<String> typeIdsList,
                                   @Param("sizeNameList")List<String> sizeNameList,
                                   @Param("typeName") String typeName);

    List<TjOrgPriceDto> getTotalPriceDetail(@Param("orgId") Long orgId,
                                            @Param("year") Integer year,
                                            @Param("typeIdsList") List<String> typeIdsList,
                                            @Param("sizeNameList") List<String> sizeNameList,
                                            @Param("levelNum") Integer levelNum,
                                            @Param("level") Integer level,
                                            @Param("column") String column,
                                            @Param("order") String order,
                                            @Param("levelFlag")Integer levelFlag,
                                            @Param("typeName")String typeName);

}
