package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.UserDto;
import com.junmp.jyzb.api.bean.dto.PolicemanDto;
import com.junmp.jyzb.api.bean.dto.SysUserRoleDto;
import com.junmp.jyzb.api.bean.dto.UserRoleDto;
import com.junmp.jyzb.api.bean.req.UpdatePolicemanReq;
import com.junmp.jyzb.entity.Policeman;
import com.junmp.v2.message.db.entity.SysMessage;
import com.junmp.v2.sys.api.bean.user.req.SysUserReq;
import com.junmp.v2.sys.user.entity.SysUser;
import org.apache.ibatis.annotations.Mapper;
import java.util.List;
import java.util.Map;import org.apache.ibatis.annotations.Param;

@Mapper
public interface PolicemanMapper extends BaseMapper<Policeman> {


    Map<String, Object> getOnePolice(String id);
    List<Policeman> getAllPolice();


    List<Map<String, Object>> getAllPolicemanByOrg(String orgId);

    List<Map<String, Object>> getAllPolicemanByOrgList(List<String> orgId);

    List<Policeman> SearchBoxBindPolice(List<String> cabinetBoxes);

    List<Policeman> SearchPoliceList( String id);

    IPage<Policeman> SearchPolicePage(Page<Policeman> page, String id);

    Long SearchPoliceSize(String id);

    void updateBatchUserIdByAccountList(@Param("userIdList") List<Long> userIdList, @Param("accountList") List<String> accountList);

    List<UserRoleDto> ShowUserRole(@Param("req") SysUserReq req,@Param("numRoles") Integer numRoles);

    List<SysUserRoleDto> selectUserRoleInfo(@Param("userId") Long userId);


    List<PolicemanDto> selectUserBypoliceIds(@Param("orgId") Long orgId, @Param("account")String account,
                                             @Param("name") String name, @Param("policeCode")String policeCode,
                                             @Param("state")Integer state,@Param("userId") Long userId,
                                             @Param("phone")String phone,@Param("flag") String flag,
                                             @Param("pageNo")Long pageNo, @Param("pageSize") Long pageSize,
                                             @Param("column") String column,@Param("order") String order,
                                             @Param("roleCodeList") List<String> roleCodeList,
                                             @Param("orgList")List<String> orgList,@Param("isAllOrgVisible")Integer isAllOrgVisible);

    long count(@Param("orgId") Long orgId, @Param("account")String account,
               @Param("name") String name, @Param("policeCode")String policeCode,
               @Param("state")Integer state,@Param("userId") Long userId,
               @Param("phone")String phone,@Param("flag") String flag,
               @Param("roleCodeList") List<String> roleCodeList,
               @Param("isAllOrgVisible")Integer isAllOrgVisible);

    List<UserDto> alignUserInfo(@Param("orgId") Long orgId, @Param("date")String date);

    List<UserDto> oneClickAccountCreation(@Param("orgId") Long orgId,@Param("account")String account,
                                          @Param("roleId")Long roleId,@Param("userRoleList") List<Long> userRoleList);
    List<UserDto> oneClickAccountCreation1(@Param("orgId") Long orgId,@Param("userRoleList") List<Long> userRoleList);

    void insertSysUser(@Param("userList") List<SysUser> sysUserList);

    String searchUserByRoleId(@Param("orgId") Long orgId,@Param("roleId")Long roleId);

    List<Long> getUserIds();

    SysUserReq selectUserById(@Param("userId") Long userId);

    List<Long> selectErrorInfo();

    List<Policeman> changeUserIdToPolice(@Param("userRoleList") List<Long> userRoleList);

    List<Policeman> getErrorPolice(Long userId);

    List<Policeman> searchPoliceWithoutOrg(@Param("req") UpdatePolicemanReq req,
                                           @Param("pageNo") Long pageNo,
                                           @Param("pageSize") Long pageSize);

    int searchPoliceWithoutOrgCount(@Param("req") UpdatePolicemanReq req);

    //查询用户消息列表（过质保期定时任务需要）
    List<SysMessage> findExpireMessageList(@Param("userList") List<String> userId);
}