package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.req.PlanInitiationReq;
import com.junmp.jyzb.api.bean.vo.PlanInitOrgTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanInitTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanOrgTypeVo;
import com.junmp.jyzb.entity.PlanInitiationItem;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2024/6/3 9:47
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Mapper
public interface PlanInitiationItemMapper extends BaseMapper<PlanInitiationItem> {

    /**
     * 查询发起预案信息详情
     * @param req
     * @return
     */
    List<PlanOrgTypeVo> getDetail(@Param("req") PlanInitiationReq req);

    /**
     * 根据预案明细获取数据信息
     * @param planId
     * @return
     */
    List<PlanInitOrgTypeVo> getPlanDetail(@Param("planId") Long planId);

    /**
     *
     * @param planId
     * @return
     */
    List<PlanInitTypeVo> getPlanInfo(@Param("planId") Long planId);
    void getPlanInfoByOrderId();
}




