package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.printDto.GetPrintOrderDto;
import com.junmp.jyzb.api.bean.dto.printDto.OrderInfoDto;
import com.junmp.jyzb.api.bean.query.OrderMainReq;
import com.junmp.jyzb.api.bean.req.PrintReq.GetPrintOrderReq;
import com.junmp.jyzb.entity.OrderMain;
import com.junmp.v2.auth.api.bean.login.LoginUser;
import com.junmp.v2.sys.user.entity.SysUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.ArrayList;
import java.util.List;

@Mapper
public interface OrderMainMapper extends BaseMapper<OrderMain> {
    Long addOrder(OrderMain order);


    void updateOrder(OrderMain order);


    IPage<OrderMain> getOrderPage(Page<OrderMain> page1,@Param("req") OrderMainReq req,@Param("userId") Long userId,
                                  @Param("startOrgId")String startOrgId,@Param("endOrgId")String endOrgId);

    List<String> getInvsListByOrder(@Param("req") OrderMainReq req, @Param("userId") Long userId);

    SysUser getUser(@Param("orgId") Long endOrgId,@Param("roleId")Long roleId);

    List<OrderMain> TjEqsSumByOrder(@Param("req") OrderMainReq req,@Param("pageNo")Long pageNo,@Param("pageSize")Long pageSize);

    int TjEqsSumByOrderCount(@Param("req") OrderMainReq req);

    Boolean updateToReturnOrder(@Param("useOrderIds") List<String> collect, @Param("returnOrderIds") List<String> collect1);

    int GetPrintOrderCount(@Param("req") GetPrintOrderReq req);

    List<GetPrintOrderDto.PrintOrderDto> GetPrintOrder(@Param("req")GetPrintOrderReq req,@Param("pageNo") Integer page,@Param("pageSize") Integer size);

    List<OrderInfoDto> getInfoByOrderDetailIds(@Param("orderDetailIdsList") List<String> orderDetailIdsList);
}