package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.PeriodAndDateDto;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.EquipmentDto;
import com.junmp.jyzb.api.bean.dto.hardWareDto.EqsDto;
import com.junmp.jyzb.api.bean.dto.hardWareDto.InvCabDto;
import com.junmp.jyzb.api.bean.dto.printDto.GetInvListByBoxMarkEpcDto;
import com.junmp.jyzb.api.bean.dto.printDto.GetPrintListDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.hardWareReq.HardWareCabReq;
import com.junmp.jyzb.api.bean.req.BatchEditingInvsReq;
import com.junmp.jyzb.api.bean.req.InvExpireReq;
import com.junmp.jyzb.api.bean.req.PrintReq.EpcInvReq;
import com.junmp.jyzb.api.bean.req.PrintReq.GetPrintListReq;
import com.junmp.jyzb.api.bean.vo.InventoryVo;
import com.junmp.jyzb.entity.Inventory;
import com.junmp.jyzb.entity.InventorySummary;
import com.junmp.jyzb.entity.WarehouseInventory;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Mapper
public interface InventoryMapper extends BaseMapper<Inventory> {


    //根据单警柜统计装备信息
    List<WarehouseInvDto> GetViewWarehouseInv(@Param("warehouseId") String warehouseId,@Param("typeIdsList") List<String> typeIdsList,@Param("sizeIds") List<String> sizeIds);
    List<ViewEquipmentDto> GetViewEquipment(@Param("epcList") List<String> epcList);
    List<EpcListDto> GetViewCountByepcs(@Param("epcList") List<String> epcList);
    List<InvSummaryDto>  selectEpcsByWarehouse(@Param("warehouseId") String warehouseId,
                                               @Param("typeIdList")List<String> typeIdList,
                                               @Param("sizeIdList")List<String> sizeIdList);

    List<InventoryMapDto> GetViewInventoryMap(@Param("warehouseId") String warehouseId);

    Boolean deleteByEpcs(@Param("list") List<String> epcs);
    Boolean deleteByEpcs1(@Param("orgId") Long orgId,@Param("locationId")String locationId);

    Boolean DeleteEpcsWithoutWarehouse(@Param("list") List<String> epcs,@Param("orgId") String orgId,@Param("warehouseId") String warehouseId);

    List<InvSummaryDto>  selectWarehouseByEpcs(@Param("list") List<String> epcs,@Param("orgId") String orgId,@Param("warehouseId") String warehouseId);

    //根据单警柜统计装备信息
    boolean SetCabinetInventory(@Param("brokenNumberDays") Integer brokenNumberDays);

    //根据仓库统计装备信息
    boolean SetWarehouseInventory(@Param("brokenNumberDays") Integer brokenNumberDays);


    //根据货架id查询汇总信息(list)
    List<InventorySummary> getSumByShelf(@Param("shelfId") String shelfId);

    //根据货架id查询汇总信息(page)
    IPage<InventorySummary> ShelfInventoryPage(@Param("page") Page<InventorySummary> page,
                                               @Param("shelfId") String shelfId);

    //根据区域id查询汇总信息(list)
    List<InventorySummary> getSumByArea(@Param("id") String id);

    //根据区域id查询汇总信息(page)
    IPage<InventorySummary> AreaInventoryPage(@Param("page") Page<InventorySummary> page,
                                              @Param("id") String id);

    //通过单警柜箱门id获取箱门下的装备汇总信息(list)
    List<InventorySummary> getSumByCabinetBox(@Param("id") String id);

    //通过查询条件查询出装备数量报表
    List<EqsSumDto> GetListEquipment(@Param("req") InventoryReq req);

    //查询组织机构下面的装备信息
    List<InventoryVo> selectListByOrg(@Param("orgId") Long orgId);


    //通过单警柜箱门id获取箱门下的装备汇总信息(page)
    IPage<InventorySummary> EqsByCabinetBoxIdPage(@Param("page") Page<InventorySummary> page,
                                                  @Param("id") String id);


     boolean insertInventorySummary(@Param("req") BatchEditingInvsReq req,
                                    @Param("brokenNumberDays")Integer brokenNumberDays);

     //判断epc是否存在
    List<String> checkEPCList(@Param("list") List<String> epcList);


    //根据epc获取装备信息
    List<InventoryDto> GetInvInfoByEpc(@Param("list") List<String> epcList);

    //通过组织机构id获取组织机构下的userIdlist
    List<InvExpireReq> selectUserListByOrgs(@Param("list") List<Long> uniqueOrgIDsList,@Param("roleId")String roleId);


    List<EquipmentDto> alignInventoryInfo(@Param("orgId")Long orgId,
                                          @Param("warehouseId") String warehouseId,
                                          @Param("date")String date,
                                          @Param("typeIdList")List<String> typeIdList,
                                          @Param("sizeIdList")List<String> sizeIdList);



    int EqsByStateSum(@Param("req") InventoryReq req);

    List<InventoryDto> EqsByState(@Param("req") InventoryReq req,
                                  @Param("pageNo") Long pageNo,
                                  @Param("pageSize") Long pageSize);

    List<PeriodAndDateDto> GetByPeriodAndDate(@Param("req") InventoryReq req);

    List<Inventory> getEqsInfo(@Param("orgId") Long orgId,@Param("locationId") String locationId,
                               @Param("typeId") String typeId, @Param("sizeId")String sizeId,
                               @Param("price")BigDecimal price, @Param("warrantyPeriod")Integer warrantyPeriod,
                               @Param("startTime") String startTime,@Param("endTime") String endTime,@Param("destruction") String destruction);


    List<Inventory> selectSum(@Param("list") List<Object[]> searchItem,@Param("epcType")Integer epcType);

    List<InventorySummary> selectInvSum(@Param("list") ArrayList<Object[]> objects);

    List<Inventory> selectInventoryByEpcList(@Param("epcList") List<String> addEpcList,String orgId);

    List<Inventory> searchEqs(@Param("list")List<String> epcList);

    List<Inventory> getInvsExceptUseState(@Param("list") List<InvSumSelectDto> collect,@Param("epcList")List<String> epcList);


    List<EqsDto.EqsInfoDto> getBindEqu(@Param("locationId") String cabinetBoxId,@Param("policemanId") String policemanId);

    int getInvCountByCab(@Param("req") HardWareCabReq req);

    List<InvCabDto.InvDto> getInvByCab(@Param("devSn") String devSn,@Param("type") String type);

    InventorySummary getSumByLocationIdList(@Param("list") Set<String> locationIdList);

    List<Inventory> getInvByCabBoxList(@Param("list") List<String> boxList,@Param("epcList") List<String> reqEpcList);

    List<Inventory> getInvEpcList(@Param("policeId") String policeId,@Param("epcList") List<String> epcList,@Param("boxId") String boxId,@Param("eqsBindState") Integer eqsBindState);

    List<Inventory> getInvByCabinetBox(@Param("boxId")String boxId);

    List<GetInvListByBoxMarkEpcDto> GetInventoryListByBoxMarkEpc(@Param("req") EpcInvReq req);

    List<Inventory> getInvWithCode(@Param("epcList") List<String> allEpcList);

    List<Inventory> getInvNamesByEpcs(@Param("epcList") List<String> epcs);

    List<GetPrintListDto.dataList> getdataXBList(@Param("req") GetPrintListReq req);

    List<Inventory> getBindEqsList(@Param("cabinetBoxId") String cabientBoxId);

    List<Inventory> getInfoList(@Param("list") List<Object[]> itemList);


    List<WarehouseInventory> getInvListByWarehouse(@Param("warehouseId") String warehouseId);
}