package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.TypeDto;
import com.junmp.jyzb.api.bean.dto.tempDto.TypeSizeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.query.hardWareReq.HardWareCabReq;
import com.junmp.jyzb.entity.EquipmentType;
import com.junmp.jyzb.entity.PubOrg;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface EquipmentTypeMapper extends BaseMapper<EquipmentType> {




    void setTypeParentIds(@Param("typeId")String typeId);

    List<String> selectByItems(@Param("list1") List<String> list1,
                               @Param("list2") List<String> list2,
                               @Param("list3") List<String> list3,
                               @Param("list4") List<String> list4);
    List<TypeSizeDto> GetNameBySizeIds(@Param("sizeIds") List<String> sizeIds);

    List<TypeDto> alignTypeInfo(@Param("date") String date);


    PubOrg getOrg(@Param("userId") Long userId);

    List<com.junmp.jyzb.api.bean.dto.hardWareDto.TypeDto> getListEquipmentDetail(@Param("req") HardWareCabReq req);

    Page<EquipmentTreeDto> getTypePage(@Param("page") Page<EquipmentTreeDto> defaultPage,
                                       @Param("req") QueryEquipmentTypeReq req,
                                       @Param("typeCodesList") List<String> typeCodesList);
}