package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.junmp.jyzb.api.bean.dto.EquipmentSizeDto;
import com.junmp.jyzb.api.bean.dto.fetchingDataDto.SizeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentSizeReq;
import com.junmp.jyzb.api.bean.query.hardWareReq.HardWareCabReq;
import com.junmp.jyzb.entity.EquipmentSize;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface EquipmentSizeMapper extends BaseMapper<EquipmentSize> {


    /**
     * 获取分页的信息
     */
    public List<EquipmentSizeDto> getSizePage(
            @Param("req") QueryEquipmentSizeReq req,
            @Param("page") Page<EquipmentSizeDto> page
    );

    /**
     * 获取分页的信息
     */
    public Integer getSizeCount(
            @Param("name") String name,
            @Param("typeId") String typeId
    );

    //根据typeId返回号型名称
    List<String> searchByTypeIds(@Param("list") List<String> typeIdsList);

    List<SizeDto> alignSizeInfo(@Param("date") String date);

    List<EquipmentSize> distinctByName(@Param("list") List<EquipmentSize> locationList);

    List<EquipmentSize> checkSizeNameList(@Param("list") List<Object[]> searchItem);

    List<com.junmp.jyzb.api.bean.dto.hardWareDto.SizeDto> getSizeList(@Param("list") List<String> collect);

    List<com.junmp.jyzb.api.bean.dto.hardWareDto.SizeDto> getListEquipmentSizeNoSign(@Param("req") HardWareCabReq req);
}