package com.junmp.jyzb.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.junmp.jyzb.api.bean.dto.InventoryDto;
import com.junmp.jyzb.api.bean.dto.hardWareDto.EqsDto;
import com.junmp.jyzb.api.bean.dto.hardWareDto.GetCabinetPolicemanMultipleDto;
import com.junmp.jyzb.api.bean.dto.hardWareDto.HardCabPoliceDto;
import com.junmp.jyzb.api.bean.query.hardWareReq.HardWareCabReq;
import com.junmp.jyzb.api.bean.query.hardWareReq.HardWarePoliceReq;
import com.junmp.jyzb.api.bean.query.hardWareReq.MapReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.entity.CabinetBox;
import com.junmp.jyzb.entity.CabinetBoxPolice;
import com.junmp.jyzb.entity.Policeman;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface CabinetMapper extends BaseMapper<Cabinet> {

    List<Cabinet> getAllCabinetByOrgList(@Param("list") List<Long> allOrgId);
    List<Cabinet> getAllCabinetsWithSingleCabinet(@Param("orgId")String orgId,@Param("policeId")String policeId);

    boolean SetInventoryInfo(String id);

    Cabinet getOneCabinetByBoxId(@Param("boxId") String boxId);

    List<HardCabPoliceDto> getAllPoliceByCabinet(@Param("req") HardWareCabReq req,@Param("orgId")Long orgId);

    List<InventoryDto> GetEpcInfo(@Param("req") HardWareCabReq req);

    EqsDto getCabinetBoxByPoliceId(@Param("req") HardWarePoliceReq req);

    List<GetCabinetPolicemanMultipleDto> getCabinetPolicemanMultiple(@Param("req") HardWareCabReq req);

    List<CabinetBoxPolice> getBoxBindUserList(@Param("cabinetRealID")String cabinetRealID,
                                              @Param("userId")String userId,
                                              @Param("boxNo")String boxNo,
                                              @Param("type")Integer type);

    List<CabinetBox> getBoxList(@Param("cabinetRealID") String cabinetRealID,@Param("type")Integer type);

    List<String> getBoxListByCab(@Param("list")List<MapReq> reqList);

    Policeman getPoliceByBoxId(@Param("boxId") String boxId);

    List<CabinetBox> getBoxIdList(@Param("cabinetId") String cabinetId,@Param("boxNumList") List<String> boxNumList);
}