//package com.junmp.jyzb.interceptor;
//
//import com.junmp.jyzb.utils.JwtUtil;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//import org.springframework.web.servlet.HandlerInterceptor;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//
//@Component
//public class TokenInterceptor implements HandlerInterceptor {
//    @Autowired
//    private JwtUtil jwtUtil;
//
//    @Override
//    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
//        // 1. 从请求头获取Token
//        String token = request.getHeader("Authorization");
//        if (token == null || !token.startsWith("Bearer ")) {
//            response.setStatus(401);
//            response.getWriter().write("{\"code\":401,\"message\":\"Token未提供\"}");
//            return false;
//        }
//
//        // 2. 提取实际Token
//        token = token.substring(7);
//
//        // 3. 验证Token有效性
//        if (!jwtUtil.validateToken(token)) {
//            response.setStatus(401);
//            response.getWriter().write("{\"code\":401,\"message\":\"Token已失效\"}");
//            return false;
//        }
//
//        // 4. 将userId存入请求属性供后续使用
//        Long userId = jwtUtil.getUserIdFromToken(token);
//        request.setAttribute("userId", userId);
//        return true;
//    }
//}