package com.junmp.jyzb.event;

import com.junmp.jyzb.api.bean.vo.CabinetEventVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * <pre>
 *
 * 描述：事件发布
 * 版本：1.0.0
 * 日期：2024/4/10 19:20
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Slf4j
@Component
public class EventPublisher {

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    /**
     * 离线事件
     */
    public void cabinetOfflineEventPublish(CabinetEventVo source) {
        CabinetOfflineEvent event = new CabinetOfflineEvent(this);
        event.setSource(source);
        applicationEventPublisher.publishEvent(event);
    }

    /**
     * 上线事件
     */
    public void cabinetOnlineEventPublish(CabinetEventVo source) {
        CabinetOnlineEvent event = new CabinetOnlineEvent(this);
        event.setSource(source);
        applicationEventPublisher.publishEvent(event);
    }
}
