package com.junmp.jyzb.event;

import com.alibaba.fastjson2.JSON;
import com.junmp.jyzb.api.bean.vo.CabinetEventVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * <pre>
 *
 * 描述：单警柜在线与离线事件监听器
 * 版本：1.0.0
 * 日期：2024/4/10 19:36
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Component
@Slf4j
public class CabinetStateEventListener {

    //@Resource
    //private CabinetAppBizService cabinetAppBizService;

    @EventListener
    @Async("threadPoolTaskExecutor")
    public void cabinetOnlineEvent(CabinetEventVo source) {
        log.info("[单警柜上线]|事件参数：{}", JSON.toJSON(source));
        //cabinetAppBizService.updateCabinetState(source.getOrgId(), source.getDevSn(), CabinetStateEnum.ONLINE);
    }

    @EventListener
    @Async("threadPoolTaskExecutor")
    public void cabinetOfflineEvent(CabinetEventVo source) {
        log.info("[单警柜离线]|事件参数：{}", JSON.toJSON(source));
        //cabinetAppBizService.updateCabinetState(source.getOrgId(), source.getDevSn(), CabinetStateEnum.OFFLINE);
    }
}
