package com.junmp.jyzb.enums;

import lombok.Getter;

/**
 * 消息类型
 *
 * @author FCG
 */
@Getter
public enum MsgType {
    /**
     * news，有效时间24h
     */
    News("news", 24 * 60 * 60 * 1000),
    Video("video", 24 * 60 * 60 * 1000),
    Goods("goods", 7 * 24 * 60 * 60 * 1000);

    private String name;
    /**
     * time to live,(ms)
     */
    private long ttl;

    MsgType(String name, long ttl) {
        this.name = name;
        this.ttl = ttl;
    }
}