package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_warranty_inventory
 */
@TableName(value ="base_warranty_inventory")
@Data
public class WarrantyInventory implements Serializable {
    /**
     * 
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 超期类型:0代表已超期，1代表即将超期
     */
    @TableField(value = "warranty_type")
    private String warrantyType;

    /**
     * 根据超期的日期算出的即将超期时间/已超期时间
     */
    @TableField(value = "days")
    private Integer days;

    /**
     * 仓库名称
     */
    @TableField(value = "location_name")
    private String locationName;

    /**
     * 仓库id
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 装备类型（0固定资产1非固定资产）
     */
    @TableField(value = "property")
    private Integer property;

    /**
     * 所属位置:0仓库，1单警柜
     */
    @TableField(value = "location_type")
    private Integer locationType;

    /**
     * 装备状态（in，out）
     */
    @TableField(value = "location_state")
    private String locationState;

    @TableField(value = "production_date")
    private Date productionDate;

    @TableField(value = "warranty_period")
    private Integer warrantyPeriod;

    @TableField(value = "police_id")
    private String policeId;

    @TableField(value = "police_name")
    private String policeName;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}