package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 
 * @TableName base_warehouse_inventory
 */
@TableName(value ="base_warehouse_inventory")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WarehouseInventory implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 组织机构Id
     */
    @TableField(value = "org_id")
    private Long orgId;
    @TableField(value = "epc_type")
    private Integer epcType;
    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    @TableField(value = "type_name")
//    @TableField(exist = false)
    private String typeName;
    @TableField(value = "size_name")
//    @TableField(exist = false)
    private String sizeName;
    @TableField(value = "org_name")
//    @TableField(exist = false)
    private String orgName;
    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 位置id
     */
    @TableField(value = "location_id", fill = FieldFill.INSERT_UPDATE)
    private String locationId;

    /**
     * 所属位置:0仓库，1单警柜
     */
    @TableField(value = "location_type")
    private String locationType;

    /**
     * EPC信息
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 0,正常，1不做提醒, 2装备导入
     */
    @TableField(value = "flag")
    private Integer flag;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 在库状态:in在库，out出库
     */
    @TableField(value = "location_state")
    private String locationState;

    /**
     * 货架位置
     */
    @TableField(value = "shelf_location")
    private String shelfLocation;

    /**
     * 货架ID
     */
    @TableField(value = "shelf_id")
    private String shelfId;

    @TableField(value = "location_name", fill = FieldFill.INSERT_UPDATE)
    private String locationName;

    //归还入库使用（物资原来所在仓库）
    @TableField(exist = false)
    private String oldLocationId;

    @TableField(exist = false)
    private Integer shelfRow;

    @TableField(exist = false)
    private Integer shelfColumn;

    @TableField(exist = false)
    private Integer shelfRange;

    /**
     * 装备状态，broken即为报废状态
     */
    @TableField(exist = false)
    private String state;
    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}