package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("sys_user")
public class User implements Serializable {
    @TableId(value = "user_id")
    private Long userId;

    @TableField(value = "real_name")
    private String realName;

    @TableField(value = "nick_name")
    private String nickName;

    private String account;

    private String password;

    //头像，存的为文件的id
    private Long avatar;

    private Date birthday;

    private String sex;

    private String email;

    private String phone;

    private String tel;

    //是否是超级管理员：Y-是，N-否
    @TableField(value = "super_admin_flag")
    private String superAdminFlag;

    //状态：1-正常，2-冻结
    @TableField(value = "status_flag")
    private String statusFlag;

    @TableField(value = "user_type")
    private Integer userType;

    @TableField(value = "last_login_ip")
    private String lastLoginIp;

    @TableField(value = "last_login_time")
    private Date lastLoginTime;

    @TableField(value = "del_flag")
    private Integer delFlag;

    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @TableField(value = "create_user")
    private Long createUser;

    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @TableField(value = "update_user")
    private Long updateUser;

    @TableField(value = "app_flag")
    private Integer appFlag;
}
