package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 制度管理表
 * @TableName base_system
 */
@TableName(value ="base_system_manage")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SystemManage implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_UUID, value = "file_id")
    private String fileId;

    /**
     * 地址
     */
    private String url;

    /**
     * 制度名称
     */
    @TableField(value = "system_name")
    private String systemName;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 排序值
     */
    @TableField(value = "sort_val")
    private Integer sortVal;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}