package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-SupplierType")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_supplier_type")
public class SupplierType implements Serializable {
    /**
     * 供应商产品ID
     */
    @TableId
    private String id;

    /**
     * 供应商代码
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 产品代码
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 状态，0:启用，1:停用
     */
    @TableField(value = "state")
    private Integer state;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "update_time")
    private Date updateTime;

    /**
     * 更新人ID
     */
    @TableField(value = "update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}
