package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@TableName(value ="bussiness_print_epcs")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PrintEpcs {

    /**
     *
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * epc
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 子单据id
     */
    @TableField(value = "order_detail_id")
    private String orderDetailId;

    /**
     * 状态
     */
    @TableField(value = "current_state")
    private Integer currentState;

    /**
     * 打印序号
     */
    @TableField(value = "num")
    private Integer num;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 生产日期
     */
    @TableField(value = "product_time")
    private Date productTime;

    /**
     * 维保期
     */
    @TableField(value = "repair_cycle")
    private Integer repairCycle;

    /**
     * 质保期
     */
    @TableField(value = "warranty_cycle")
    private Integer warrantyCycle;

    /**
     * 时间
     */
    @TableField(value = "use_time")
    private Date useTime;

    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     *
     */
    @TableField(value = "use_direction")
    private Integer useDirection;

    /**
     * 供应商id
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 供应商名称
     */

    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 货架id
     */
    @TableField(value = "shelf_id")
    private String shelfId;

    /**
     * 行（货架位置）
     */
    @TableField(value = "shelf_row")
    private Integer shelfRow;

    /**
     * 排（货架位置）
     */
    @TableField(value = "shelf_range")
    private Integer shelfRange;

    /**
     * 列（货架位置）
     */
    @TableField(value = "shelf_column")
    private Integer shelfColumn;

    /**
     * 标签TID
     */
    @TableField(value = "tid")
    private String tid;

    @TableField(exist = false)
    private String orgId;
    @TableField(exist = false)
    private String warehouseId;
    @TableField(exist = false)
    private String warehouseName;

    @TableField(exist = false)
    private String policeId;

    @TableField(exist = false)
    private String sizeId;
    @TableField(exist = false)
    private String sizeName;
    @TableField(exist = false)
    private String typeId;
    @TableField(exist = false)
    private String typeName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
