package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-Policeman")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_policeman")
public class Policeman implements Serializable {

    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    @TableField(value = "name")
    private String name;

    @TableField(value = "user_local_id")
    private String userLocalId;

    @TableField(value = "org_id_int",updateStrategy  = FieldStrategy.IGNORED)
    private Long orgId;

    @TableField(exist = false)
    private String orgName;

    @TableField(value = "org_id")
    private String orgGuid;

    @TableField(value = "department_id")
    private Long departmentId;

    @TableField(value = "police_code")
    private String policeCode;

    @TableField(value = "face_info",updateStrategy  = FieldStrategy.IGNORED)
    private String faceInfo;
    //2.0人脸信息
    private String faceInfo2;

    @TableField(value = "door_code")
    private String doorCode;

    @TableField(value = "password",updateStrategy  = FieldStrategy.IGNORED)
    private String password;
    //2.0密码
    private String psd;

    @TableField(value = "file_id")
    private Long fileId;

    @TableField(value = "photo",updateStrategy  = FieldStrategy.IGNORED)
    private String photo;

    @TableField(value = "phone",updateStrategy = FieldStrategy.IGNORED)
    private String phone;

    @TableField(value = "tel",updateStrategy = FieldStrategy.IGNORED)
    private String tel;
    @TableField(value = "id_card")
    private String idCard;

    /**
     * 0表示警员，1表示辅警
     */
    @TableField(value = "identity")
    private Integer identity;
//    private  SysUser  uesrList;

    @TableField(fill = FieldFill.INSERT, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.UPDATE, value = "update_time")
    private Date updateTime;



//    @TableField(value = "update_user")
//    private String updateUser;

    @TableField(value = "state")
    private Integer state;

    @TableField(value = "user_id",updateStrategy  = FieldStrategy.IGNORED)
    private Long userId;



    /**
     * 海康人脸机
     */
    @TableField(value = "hk_face_device")
    private Integer hkFaceDevice;

    @TableField(exist = false)
    private List<PoliceEquipment> policeEquipmentList;

    private static final long serialVersionUID = 1L;
}