package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 
 * @TableName base_police_equipment_detail
 */
@TableName(value ="base_police_equipment_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PoliceEquipmentDetail implements Serializable {
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 警员id
     */
    @TableField(value = "police_id")
    private String policeId;

    /**
     * epc
     */
    @TableField(value = "epc")
    private String epc;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private String orgId;

    /**
     * 位置id
     */
    @TableField(value = "location_id")
    private String locationId;

    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    @TableField(value = "location_state")
    private String locationState;

    @TableField(value = "property")
    private Integer property;

    @TableField(value = "dev_sn")
    private String devSn;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}