package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * <pre>
 *
 * 描述：预案发起详情表
 * 版本：1.0.0
 * 日期：2024/6/2 15:17
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@TableName(value ="plan_initiation_item")
@Data
public class PlanInitiationItem implements Serializable {
    /**
     * 主键
     */
    @TableId(value = "item_id", type = IdType.AUTO)
    private Long itemId;

    /**
     * 预案发起主键
     */
    @TableField("plan_id")
    private Long planId;

    /**
     * 物资类型外键
     */
    @TableField("type_id")
    private String typeId;

    /**
     * 物资类型名称(冗余字段)
     */
    @TableField("type_name")
    private String typeName;

    /**
     * 发物单位
     */
    @TableField("start_org_id")
    private String startOrgId;

    /**
     * 发物单位名称
     */
    @TableField("start_org_name")
    private String startOrgName;

    /**
     * 可用数量\当前库存数
     */
    @TableField("stock_num")
    private Integer stockNum;

    /**
     * 数量
     */
    @TableField("plan_num")
    private Integer planNum;

    /**
     * 数量
     */
    @TableField("real_num")
    private Integer realNum;

    /**
     * 调拨单主键
     */
    @TableField("order_id")
    private String orderId;
}
