package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.junmp.jyzb.api.bean.vo.PlanInitTypeVo;
import com.junmp.jyzb.api.bean.vo.PlanTypeVo;
import com.junmp.v2.db.api.entity.BaseEntity;
import liquibase.pro.packaged.I;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <pre>
 *
 * 描述：预案发起表
 * 版本：1.0.0
 * 日期：2024/6/2 15:17
 * 作者：hanz@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@TableName(value ="plan_initiation")
@Data
public class PlanInitiation extends BaseEntity implements Serializable {
    /**
     * 预案发起主键
     */
    @TableId(value = "plan_id", type = IdType.AUTO)
    private Long planId;

    /**
     * 预案名称
     */
    @TableField("plan_name")
    private String planName;

    /**
     * 收物单位
     */
    @TableField("end_org_id")
    private Long endOrgId;

    /**
     * 收物单位名称
     */
    @TableField("end_org_name")
    private String endOrgName;

    /**
     * 发起单位
     */
    @TableField("start_org_id")
    private Long startOrgId;

    /**
     * 发起单位名称
     */
    @TableField("start_org_name")
    private String startOrgName;


    /**
     * 预案单号
     */
    @TableField("plan_code")
    private String planCode;
    /**
     * 收物单位负责人ID
     */
    @TableField("end_org_user_id")
    private String endOrgUserId;

    /**
     * 收物单位负责人
     */
    @TableField("end_org_user_name")
    private String endOrgUserName;

    /**
     * 发起时间
     */
    @TableField("start_time")
    private String startTime;

    /**
     * 结束时间
     */
    @TableField("end_time")
    private String endTime;

    /**
     * 接收地点
     */
    private String place;

    /**
     * 备注\描述
     */
    private String note;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 模块主键
     */
    @TableField("tem_id")
    private Long temId;

    /**
     * 预案单状态（0-草稿;1-待下发;2-待归还;3已完成）
     */
    private Integer state;

    /**
     * 预案地址
     */
    @TableField(value = "attachment_location")
    private String attachmentLocation;

    @TableField(exist = false)
    private List<PlanTypeVo> detailList;
}
