package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@TableName(value ="bussiness_order_print_num")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OrderPrintNum  implements Serializable {

    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID )
    private String id;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 单子类型
     (领:领用
     支:调拨
     价:调拨
     废:报废
     销:销毁
     入:采购
     赠:赠与
     还:归还
     其:其他
     )
     */
    @TableField(value = "order_type")
    private String orderType;

    /**
     * 年份
     */
    @TableField(value = "order_year")
    private Integer orderYear;

    /**
     * 单子计数
     */
    @TableField(value = "order_count")
    private Integer orderCount;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;



}
