package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.junmp.jyzb.api.bean.req.UpdateOrderDetailReq;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("bussiness_order_main")
public class OrderMain implements Serializable {
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    @TableField("order_type")
    private String orderType;

    @TableField(value = "process_id",updateStrategy = FieldStrategy.IGNORED)
    private String processId;

    @TableField("bussiness_type")
    private String bussinessType;

    @TableField("order_code")
    private String orderCode;

    @TableField("bussiness_code")
    private String bussinessCode;

    @TableField("start_org_id")
    private Long startOrgId;

    @TableField("start_org_name")
    private String startOrgName;

    @TableField("end_org_id")
    private Long endOrgId;

    @TableField("end_org_name")
    private String endOrgName;

    @TableField("supplier_id")
    private String supplierId;
    @TableField("supplier_name")
    private String supplierName;

    @TableField("start_org_user_id")
    private String startOrgUserId;

    @TableField("start_org_user_name")
    private String startOrgUserName;

    @TableField("end_org_user_id")
    private String endOrgUserId;

    @TableField("end_org_user_name")
    private String endOrgUserName;

    @TableField("examine_state")
    private String examineState;

    @TableField("form_item")
    private String formItem;


    @TableField("price")
    private BigDecimal price;

    @TableField("inventory_quantity")
    private Integer inventoryQuantity;

    @TableField("actual_quantity")
    private Integer actualQuantity;

    @TableField("manual_state")
    private Integer manualState;

    @TableField("order_state")
    private String orderState;

    @TableField("attachment_location")
    private String attachmentLocation;

    @TableField("inv_list")
    private String invList;
    @TableField("current_assign")
    private String currentAssign;

    @TableField("history_assign")
    private String historyAssign;

    @TableField("use_date")
    private Date useDate;


    @TableField("note")
    private String note;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;

    @TableField("create_user")
    private String createUser;

    @TableField("update_user")
    private String updateUser;


    /**
     * 调拨类型（2支拨，1价拨）
     */
    @TableField("allocate_type")
    private String allocateType;
    /**
     * 归还人，归还入库特有
     */
    @TableField("return_user_id")
    private String returnUserId;

    @TableField("return_user")
    private String returnUser;

    @TableField("return_date")
    private Date returnDate;

    /**
     * 移仓库id
     */
    @TableField("location_id")
    private String locationId;
    /**
     * 移入仓库名称
     */
    @TableField("location_name")
    private String locationName;

    /**
     * 移出仓库id
     */
    @TableField("remove_location_id")
    private String removeLocationId;
    /**
     * 移出仓库名称
     */
    @TableField("remove_location_name")
    private String removeLocationName;

    @TableField("is_print")
    private String isPrint;

    @TableField("detail_json")
    private String detailJson;

    @TableField("eqs_json")
    private String eqsJson;

    //单据当前状态(1可绑单据，0不可绑单据)
    @TableField("order_current_state")
    private Integer orderCurrentState;

    //是否推送消息（仅自动生成调拨入库单使用）
    @TableField(exist = false)
    private Boolean isSendMsg;

    /**
     * 打印单号
     */
    @TableField(value = "print_code")
    private String printCode;

    /**
     * '打印单号创建时间'
     */
    @TableField(value = "print_code_time")
    private Date printCodeTime;

    @TableField(value = "is_open")
    private Integer isOpen;

    /**
     * 0或null未下发，1已下发
     */
    @TableField(value = "sync_flag")
    private Integer syncFlag;
    /**
     * 工作流ID
     */
    @TableField(exist = false)
    private String  processDefinitionId;
    /**
     * 明细列表
     */
    @TableField(exist = false)
    private List<UpdateOrderDetailReq> detailList;

    @TableField(value = "destruction_source")
    private String destructionSource;

    private static final long serialVersionUID = 1L;
}