package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @TableName common_jp_transfer_order
 */
@TableName(value ="common_jp_transfer_order")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpTransferOrder implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 发物单位id
     */
    @TableField(value = "send_org_id")
    private Long sendOrgId;

    /**
     * 发物单位名称
     */
    @TableField(value = "send_org_name")
    private String sendOrgName;

    /**
     * 收物单位id
     */
    @TableField(value = "receiver_org_id")
    private Long receiverOrgId;

    /**
     * 收物单位名称
     */
    @TableField(value = "receiver_org_name")
    private String receiverOrgName;

    /**
     * 收物单位仓库id
     */
    @TableField(value = "receive_warehouse_id")
    private String receiveWarehouseId;

    /**
     * 收物单位仓库名称
     */
    @TableField(value = "receive_warehouse_name")
    private String receiveWarehouseName;

    /**
     * 当前状态
     */
    @TableField(value = "current_state")
    private Integer currentState;

    /**
     * 申请时间
     */
    @TableField(value = "apply_time")
    private Date applyTime;

    /**
     * 订单号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 类型
     */
    @TableField(value = "action_type")
    private Integer actionType;

    /**
     * 打印单号
     */
    @TableField(value = "transfer_print_code")
    private String transferPrintCode;

    /**
     * 打印时间
     */
    @TableField(value = "transfer_print_time")
    private Date transferPrintTime;

    /**
     * 申请人id
     */
    @TableField(value = "apply_id")
    private String applyId;

    /**
     * 申请人名称
     */
    @TableField(value = "apply_name")
    private String applyName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}