package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 *
 * @TableName common_jp_transfer_detail
 */
@TableName(value ="common_jp_transfer_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpTransferDetail implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 主单id
     */
    @TableField(value = "order_id")
    @NotEmpty(message = "主单据id不能为空",groups = {ValidationApi.list.class})
    private String orderId;

    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 状态
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 计划数量
     */
    @TableField(value = "plan_num")
    private Integer planNum;

    /**
     * 实际数量
     */
    @TableField(value = "real_num")
    private Integer realNum;

    /**
     * 发物单位id
     */
    @TableField(value = "send_warehouse_id")
    private String sendWarehouseId;

    /**
     * 发物单位名称
     */
    @TableField(value = "send_warehouse_name")
    private String sendWarehouseName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}