package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @TableName common_jp_purchase_order
 */
@TableName(value ="common_jp_purchase_order")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpPurchaseOrder implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 单号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 组织机构简称
     */
    @TableField(value = "d_name")
    private String dName;

    /**
     * 单子状态（1已完成，0未完成）
     */
    @TableField(value = "current_state")
    private Integer currentState;

    /**
     * 申请人id
     */
    @TableField(value = "apply_id")
    private String applyId;

    /**
     * 申请原因
     */
    @TableField(value = "apply_reason")
    private String applyReason;

    /**
     * 申请人名称
     */
    @TableField(value = "apply_name")
    private String applyName;

    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 仓库名称
     */
    @TableField(value = "warehouse_name")
    private String warehouseName;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 打印单号
     */
    @TableField(value = "print_order_code")
    private String printOrderCode;

    /**
     * 打印时间
     */
    @TableField(value = "print_order_time")
    private Date printOrderTime;

    /**
     * 备注
     */
    @TableField(value = "note")
    private String note;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}