package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 *
 * @TableName common_jp_purchase_detail
 */
@TableName(value ="common_jp_purchase_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpPurchaseDetail implements Serializable {
    /**
     * 子单id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 主单id
     */
    @TableField(value = "order_id")
    @NotEmpty(message = "主单据id不能为空",groups = {ValidationApi.list.class})
    private String orderId;

    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 供应商id
     */
    @TableField(value = "supplier_id")
    private String supplierId;

    /**
     * 数量
     */
    @TableField(value = "quantity")
    private Integer quantity;

    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 备注
     */
    @TableField(value = "note")
    private String note;

    /**
     * 实际数量
     */
    @TableField(value = "real_count")
    private Integer realCount;

    /**
     * 状态（1已完成，0未完成）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}