package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @TableName common_jp_noborrow_order
 */
@TableName(value ="common_jp_noborrow_order")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpNoborrowOrder implements Serializable {
    /**
     * id主键
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 仓库名称
     */
    @TableField(value = "warehouse_name")
    private String warehouseName;

    /**
     * 单号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 出入库状态（1入库，0出库）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构简称
     */
    @TableField(value = "d_name")
    private String dName;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}