package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 *
 * @TableName common_jp_noborrow_detail
 */
@TableName(value ="common_jp_noborrow_detail")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpNoborrowDetail implements Serializable {
    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 主单据id
     */
    @TableField(value = "order_id")
    @NotEmpty(message = "主单据id不能为空",groups = {ValidationApi.list.class})
    private String orderId;

    /**
     * 类型id
     */
    @TableField(value = "type_id")
    private String typeId;

    /**
     * 类型名称
     */
    @TableField(value = "type_name")
    private String typeName;

    /**
     * 号型id
     */
    @TableField(value = "size_id")
    private String sizeId;

    /**
     * 号型名称
     */
    @TableField(value = "size_name")
    private String sizeName;

    /**
     * 数量
     */
    @TableField(value = "count")
    private Integer count;

    /**
     * 出入库状态（1入库，0出库）
     */
    @TableField(value = "out_in_state")
    private Integer outInState;

    /**
     * 借用类型（13本仓库借用入库，14本仓库借用出库）
     */
    @TableField(value = "type")
    private Integer type;

    /**
     * 入库时间
     */
    @TableField(value = "in_time")
    private Date inTime;

    /**
     * 出库时间
     */
    @TableField(value = "out_time")
    private Date outTime;

    /**
     * 警员id
     */
    @TableField(value = "police_id")
    private String policeId;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}