package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @TableName common_jp_fix_useless_order
 */
@TableName(value ="common_jp_fix_useless_order")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpFixUselessOrder implements Serializable {
    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 单子编号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 单据简称
     */
    @TableField(value = "d_name")
    private String dName;

    /**
     * 状态
     */
    @TableField(value = "current_state")
    private Integer currentState;

    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 仓库名称
     */
    @TableField(value = "warehouse_name")
    private String warehouseName;

    /**
     * 申请人id
     */
    @TableField(value = "apply_id")
    private String applyId;

    /**
     * 申请人
     */
    @TableField(value = "apply_name")
    private String applyName;

    /**
     * 类型（0维修，1报废）
     */
    @TableField(value = "action")
    private Integer action;

    /**
     * 备注
     */
    @TableField(value = "note")
    private String note;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 打印单单号
     */
    @TableField(value = "print_order_code")
    private String printOrderCode;

    /**
     * 打印时间
     */
    @TableField(value = "print_order_time")
    private Date printOrderTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}