package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @TableName common_jp_borrow_return_order
 */
@TableName(value ="common_jp_borrow_return_order")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JpBorrowReturnOrder implements Serializable {
    /**
     * id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 当前状态（0未开始，1已出库，2已入库）
     */
    @TableField(value = "current_state")
    private Integer currentState;

    /**
     * 类型（0借用1领用）
     */
    @TableField(value = "action_type")
    private Integer actionType;

    /**
     * 订单号
     */
    @TableField(value = "order_code")
    private String orderCode;

    /**
     * 申请人id
     */
    @TableField(value = "apply_id")
    private String applyId;

    /**
     * 申请人
     */
    @TableField(value = "apply_name")
    private String applyName;

    /**
     * 组织机构id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 仓库id
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;

    /**
     * 仓库名称
     */
    @TableField(value = "warehouse_name")
    private String warehouseName;

    /**
     * 组织机构简称
     */
    @TableField(value = "d_name")
    private String dName;

    /**
     * 打印单号
     */
    @TableField(value = "print_order_code")
    private String printOrderCode;

    /**
     * 打印时间
     */
    @TableField(value = "print_order_time")
    private Date printOrderTime;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;


}